-------------------------------------------------------
-- Created by Ben Cope of Imperial College (June 2005)
-- Evaluate multiplication Block for Filter 10x10
-------------------------------------------------------

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;
USE IEEE.std_logic_arith.ALL;

LIBRARY work;
USE work.Constants.ALL;
USE work.ALL;

ENTITY Evaluate IS
    PORT (clock : IN STD_LOGIC;
          reset : IN STD_LOGIC;
			 RGB_compute : IN Channel_nxn;
			 compute : IN STD_LOGIC;
			 output_valid: OUT STD_LOGIC;
			 output : OUT VectorRGB);
END Evaluate;

ARCHITECTURE inside OF Evaluate IS

SIGNAL result : VectorRes_nxn;
SIGNAL min0 : VectorRGB_ex;
SIGNAL min : VectorRGB_ex_nxn;
SIGNAL result_small_pr : VectorRGB_ex_nxn;
SIGNAL result_small : VectorRGB_ex_nxn;
SIGNAL rounding : VectorRGB_ex_nxn;
SIGNAL pre_output : VectorRGB_ex;

SIGNAL valid: STD_LOGIC_VECTOR(0 TO 10);

BEGIN

 --------------------------------------------
 -- MULTIPLIER INSTANTIATIONS
 --------------------------------------------
 
G1: FOR i IN 0 TO n-1 GENERATE -- width n
 G2: FOR j IN 0 TO n-1 GENERATE -- height n
  G3: FOR k IN 0 TO 2 GENERATE -- For each RGB
   M1: ENTITY Multiplier_model
   PORT MAP(
    P => result(i)(j)(k),
 	 A => RGB_compute(i)(j).RGB(k),
	 B => matrix(i)(j),
	 C => clock,
	 CE => '1',
	 R => reset);
  END GENERATE;
 END GENERATE;
END GENERATE;

 --------------------------------------------
 -- ADDER TREE
 --------------------------------------------

P1: PROCESS 

BEGIN
 WAIT UNTIL Rising_Edge(clock);

 IF reset = '1' THEN
	FOR k IN 0 TO 2 LOOP
	 output(k) <= (OTHERS => '0');
	END LOOP;
 ELSE
  
  -- Multiplication (3 Cycle delay)

  
   -- Rounding (2 cycle delay)
   FOR i IN 0 TO n-1 LOOP
    FOR j IN 0 TO n-1 LOOP
	  FOR k IN 0 TO 2 LOOP
	   result_small_pr(i)(j)(k) <= result(i)(j)(k)(RGB_width*2-2 DOWNTO RGB_width*2-2-RGB_width);
 	   rounding(i)(j)(k) <= "00000000" & result(i)(j)(k)(RGB_width*2-2-RGB_width-1);
 	   result_small(i)(j)(k) <= signed(result_small_pr(i)(j)(k)) + signed(rounding(i)(j)(k));
	  END LOOP;
	 END LOOP;
   END LOOP;
 
  -- Perform Additions (change for each n)
  FOR k IN 0 TO 2 LOOP
   	-- 1 cycle delay
	 FOR i IN 0 TO 4 LOOP
	  min(i)(0)(k) <= signed(result_small(2*i)(0)(k)) + signed(result_small(2*i)(1)(k));
	  min(i)(1)(k) <= signed(result_small(2*i)(2)(k)) + signed(result_small(2*i)(3)(k));
	  min(i)(2)(k) <= signed(result_small(2*i)(4)(k)) + signed(result_small(2*i)(5)(k));
	  min(i)(3)(k) <= signed(result_small(2*i)(6)(k)) + signed(result_small(2*i)(7)(k));
	  min(i)(4)(k) <= signed(result_small(2*i)(8)(k)) + signed(result_small(2*i)(9)(k));
	  min(i)(5)(k) <= signed(result_small(2*i+1)(0)(k)) + signed(result_small(2*i+1)(1)(k));
	  min(i)(6)(k) <= signed(result_small(2*i+1)(2)(k)) + signed(result_small(2*i+1)(3)(k));
	  min(i)(7)(k) <= signed(result_small(2*i+1)(4)(k)) + signed(result_small(2*i+1)(5)(k));
	  min(i)(8)(k) <= signed(result_small(2*i+1)(6)(k)) + signed(result_small(2*i+1)(7)(k));
	  min(i)(9)(k) <= signed(result_small(2*i+1)(8)(k)) + signed(result_small(2*i+1)(9)(k));
	 END LOOP;


-- 1 cycle delay
	 FOR i IN 0 TO 1 LOOP
	  min(i+5)(0)(k) <= signed(min(2*i)(0)(k)) + signed(min(2*i)(1)(k));
	  min(i+5)(1)(k) <= signed(min(2*i)(2)(k)) + signed(min(2*i)(3)(k));
	  min(i+5)(2)(k) <= signed(min(2*i)(4)(k)) + signed(min(2*i)(5)(k));
	  min(i+5)(3)(k) <= signed(min(2*i)(6)(k)) + signed(min(2*i)(7)(k));
	  min(i+5)(4)(k) <= signed(min(2*i)(8)(k)) + signed(min(2*i)(9)(k));
	  min(i+5)(5)(k) <= signed(min(2*i+1)(0)(k)) + signed(min(2*i+1)(1)(k));
	  min(i+5)(6)(k) <= signed(min(2*i+1)(2)(k)) + signed(min(2*i+1)(3)(k));
	  min(i+5)(7)(k) <= signed(min(2*i+1)(4)(k)) + signed(min(2*i+1)(5)(k));
	  min(i+5)(8)(k) <= signed(min(2*i+1)(6)(k)) + signed(min(2*i+1)(7)(k));
	  min(i+5)(9)(k) <= signed(min(2*i+1)(8)(k)) + signed(min(2*i+1)(9)(k));
	 END LOOP;
	 min(7)(0)(k) <= signed(min(4)(0)(k)) + signed(min(4)(1)(k));
	 min(7)(1)(k) <= signed(min(4)(2)(k)) + signed(min(4)(3)(k));
	 min(7)(2)(k) <= signed(min(4)(4)(k)) + signed(min(4)(5)(k));
	 min(7)(3)(k) <= signed(min(4)(6)(k)) + signed(min(4)(7)(k));
	 min(7)(4)(k) <= signed(min(4)(8)(k)) + signed(min(4)(9)(k));

-- 1 cycle delay

	  min(7)(5)(k) <= signed(min(7)(0)(k)) + signed(min(7)(1)(k));
	  min(7)(6)(k) <= signed(min(7)(2)(k)) + signed(min(7)(3)(k));
	  min(7)(7)(k) <= min(7)(4)(k);

	  min(8)(0)(k) <= signed(min(5)(0)(k)) + signed(min(5)(1)(k));
	  min(8)(1)(k) <= signed(min(5)(2)(k)) + signed(min(5)(3)(k));
	  min(8)(2)(k) <= signed(min(5)(4)(k)) + signed(min(5)(5)(k));
	  min(8)(3)(k) <= signed(min(5)(6)(k)) + signed(min(5)(7)(k));
	  min(8)(4)(k) <= signed(min(5)(8)(k)) + signed(min(5)(9)(k));
	  min(8)(5)(k) <= signed(min(6)(0)(k)) + signed(min(6)(1)(k));
	  min(8)(6)(k) <= signed(min(6)(2)(k)) + signed(min(6)(3)(k));
	  min(8)(7)(k) <= signed(min(6)(4)(k)) + signed(min(6)(5)(k));
	  min(8)(8)(k) <= signed(min(6)(6)(k)) + signed(min(6)(7)(k));
	  min(8)(9)(k) <= signed(min(6)(8)(k)) + signed(min(6)(9)(k));

-- 1 cycle delay
	 min(7)(8)(k) <= signed(min(7)(5)(k)) + signed(min(7)(6)(k));
	 min(7)(9)(k) <= min(7)(7)(k);
	 
	 min(9)(0)(k) <= signed(min(8)(0)(k)) + signed(min(8)(1)(k));
	 min(9)(1)(k) <= signed(min(8)(2)(k)) + signed(min(8)(3)(k));
	 min(9)(2)(k) <= signed(min(8)(4)(k)) + signed(min(8)(5)(k));
	 min(9)(3)(k) <= signed(min(8)(6)(k)) + signed(min(8)(7)(k));
	 min(9)(4)(k) <= signed(min(8)(8)(k)) + signed(min(8)(9)(k));

-- 1 cycle delay
	 min(9)(5)(k) <= signed(min(7)(8)(k)) + signed(min(7)(9)(k));
	 min(9)(6)(k) <= signed(min(9)(0)(k)) + signed(min(9)(1)(k));
	 min(9)(7)(k) <= signed(min(9)(2)(k)) + signed(min(9)(3)(k));
	 min(9)(8)(k) <= min(9)(4)(k);

-- 1 cycle delay
	 min(9)(9)(k) <= signed(min(9)(5)(k)) + signed(min(9)(6)(k));
	 min0(k) <= signed(min(9)(7)(k)) + signed(min(9)(8)(k));

-- 2 cycle delay
	 Pre_output(k) <= signed(min(9)(9)(k)) + signed(min0(k));
	 output(k) <= Pre_output(k)(RGB_width-1 DOWNTO 0);
  END LOOP;

  END IF;

END PROCESS P1;

--------------------------------------------
 -- Organise Valid Signals
 --------------------------------------------

valid_proc: PROCESS

BEGIN

  WAIT UNTIL Rising_Edge(clock);

  IF reset = '1' THEN
	
   valid <= (OTHERS => '0');
	output_valid <= '0';
  ELSE
 
 -- ORGANISE VALID 
 valid(0) <= compute AND RGB_compute(4)(4).valid;
 valid(1 TO 10) <= valid(0 TO 9);
 output_valid <= valid(10);

 END IF;

END PROCESS valid_proc;

END inside;

